using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class WKF_CASEDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public WKF_CASEDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods
        
        public WKF_CASE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            WKF_CASE objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }
      
        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            Int32? objReturn = objSave.WKF_CASE_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CASE_DUE_DATE, objSave.CASE_NUMBER, objSave.CASE_START_DATE, DateTime.Now, objSave.CREATEDBY, objSave.PARENT_CASE_ID, objSave.PATIENT_ID, objSave.REFERRAL_ID, objSave.STD_WKFCASETYPE_ID, DateTime.Now, objSave.UPDATEDBY, ref objReturn, objSave.STD_WKFCASESTS_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }
       
        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;
            List<STD_WKFCASETYPE> objTemp = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_WKF_CASE_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = dbContext.usp_STD_WKFCASETYPE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = objTemp.Where(r => r.STD_REGISTRY_ID == CURRENT_REGISTRY_ID).ToList();
                    objReturn = dbContext.usp_WKF_CASE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objReturn != null && objTemp != null)
                        objReturn = (from s in objReturn where (from t in objTemp select t.ID).Contains(s.STD_WKFCASETYPE_ID) select s).ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (WKF_CASE wkf in objReturn)
                        {
                            if (wkf.PATIENT_ID > 0)
                            {
                                wkf.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, wkf.PATIENT_ID).FirstOrDefault();
                            }

                            if (wkf.STD_WKFCASETYPE_ID > 0)
                            {
                                wkf.STD_WKFCASETYPE = dbContext.usp_STD_WKFCASETYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, wkf.STD_WKFCASETYPE_ID).FirstOrDefault();
                            }

                            if (wkf.STD_WKFCASESTS_ID > 0)
                            {
                                wkf.STD_WKFCASESTS = dbContext.usp_STD_WKFCASESTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, wkf.STD_WKFCASESTS_ID).FirstOrDefault();
                            }

                            if (wkf.REFERRAL_ID != null && wkf.REFERRAL_ID.Value > 0)
                            {
                                wkf.REFERRAL = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, wkf.REFERRAL_ID.Value).FirstOrDefault();
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID, Int32 STD_WKFCASESTS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_updateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, STD_WKFCASESTS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
